﻿///
/// 7-Zip コーデックを管理するクラスのヘッダファイル。
///

#if       !defined(INCLUDED_SZ_CODEC_MANAGER)
#define            INCLUDED_SZ_CODEC_MANAGER

#if       !defined(INCLUDED_SZ_COMMON)
#include  <szCommon.hpp>
#endif // !defined(INCLUDED_SZ_COMMON)

#if       !defined(INCLUDED_SZ_ARCHIVE_HANDLER)
#include  <szArchiveHandler.hpp>
#endif // !defined(INCLUDED_SZ_ARCHIVE_HANDLER)

#if       !defined(INCLUDED_SZ_FORWARD_DECLARATIONS)
#include  <szForwardDeclarations.hpp>
#endif // !defined(INCLUDED_SZ_FORWARD_DECLARATIONS)

SZ_NS_BEG(szpp)

/// <summary>
/// 7-Zip コーデックを管理する静的クラス。
/// </summary>
/// <notes>
/// 当たり前のことだが、クライアントがやりたいことは次のように分類できる:
/// <TABLE>
/// <B>操作</B>   <B>入力</B>   <B>出力</B>   <B>形式</B>
/// 展開          あり          なし          既知（入力）
/// 更新          あり          あり          既知（入力）
/// 新規          なし          あり          既知（ユーザー指定）
/// </TABLE>
/// 展開と更新については予め列挙を行ってアーカイブ形式を調べた上で、それにしたがって処理を行う。
/// 新規作成の場合は入力アーカイブは存在しないので、ユーザーが指定したアーカイブ形式で新規作成する。
/// </notes>
class SZ_SPEC CodecManager : boost::noncopyable
{
public:

  /// <summary>
  /// アーカイブの展開処理を行うコントロールクラスのインスタンスを作成する静的メソッド。
  /// </summary>
  static ArchiveExtractor *CreateExtractor(ArchiveVolume *volume, const ArchiveHandler *handler);

  /// <summary>
  /// アーカイブの新規作成または更新処理を行うコントロールクラスのインスタンスを作成する静的メソッド。
  /// </summary>
  static ArchiveUpdater *CreateUpdater(const ArchiveHandler *handler);

  /// <summary>
  /// コーデックの情報を一覧のままで返す静的メソッド。ArchiveDetector のような内部クラス向け。
  /// </summary>
  static CCodecs *GetCodecs();

  /// <summary>
  /// 特定のインデックスのハンドラを返す静的メソッド。ArchiveDetector のような内部クラス向け。
  /// </summary>
  static const ArchiveHandler &GetHandler(ArchiveHandlerIndex index);

  /// <summary>
  /// クライアント終了時に呼び出すリソースクリーンナップ関数。
  /// どのみちプロセスが消える場合には呼ぶ必要はないが、メモリリークとして報告されるのを避けるために用意されている。
  /// </summary>
  static void Shutdown();

private:

  /// <summary>
  /// シングルトン作成メソッド。
  /// </summary>
  static CodecManager *GetCodecManager();

  CodecManager();
  ~CodecManager();

  boost::ptr_vector<ArchiveHandler> handlers;
  CCodecs *codecs;
};

SZ_NS_END(szpp)

#endif // !defined(INCLUDED_SZ_CODEC_MANAGER)
